﻿/*
 * these values are used for 2 purposes: determining if a value has changed and
 *  checking if there was an error for a control
 *
 *  0 means that an item wasn"t changed and there were no errors
 *  1 means that an item was changed but there were no errors
 *  2 means that an item was changed and there was an errors
 *
 * when a control recieves focus, these arrays are checked and if there is a
 *  control that has an error, we"ll move the focus there instead
 */
var ip_addr_set    = 0;
var mask_set       = 0;
var gateway_set    = 0;
var inp_switch_set = 0;
var inp_name_set   = 0;
var speed_sel_set  = 0;

// page state flag
var PageLoadFlag = 0;

// card and gbe values for the page being displayed
var card_index;//a
var gbe_index;//b
var global_gbe_index;//a/b
var language;
var userName;

function SetColor(obj, color)
{
	obj.style.backgroundColor = color;
}

function IPChange(obj)
{
	var IP = obj.value;
	if(Validate_IPAddress(IP) == false)
	{	
		if(language == 0)
		{
			alert("Invalid IP address. Please enter a valid IP address.");
		}
		else
		{
			alert("无效的IP地址，请输入一个有效的IP地址。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		ip_addr_set = 2;
		SetColor(obj, "Red");
		return false;
	}
	else
	{
		ip_addr_set = 1;
		SetColor(obj, "Yellow");
		EnableApply();
		return true;
	}
}

function MaskChange(obj)
{
	var Mask = obj.value;
	if(Valid_Mask(Mask) == false)
	{
		if(language == 0)
		{
			alert("Invalid Subnet Mask. Please enter a valid Subnet Mask.");
		}
		else
		{
			alert("无效的子网掩码，请输入一个有效的子网掩码。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		mask_set = 2;
		SetColor(obj, "Red");
		return false;
	}
	else
	{
		mask_set = 1;
		SetColor(obj, "Yellow");
		EnableApply();
		return true;
	}
}

function GatewayChange(obj)
{
	var Gateway = obj.value;
	if(Validate_IP_Format(Gateway) == false)
	{
		if(language == 0)
		{
			alert("Invalid Gateway. Please enter a valid Gateway.");
		}
		else
		{
			alert("无效的网关，请输入一个有效的网关。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		gateway_set = 2;
		SetColor(obj, "Red");
		return false;
	}
	else
	{
		gateway_set = 1;
		SetColor(obj, "Yellow");
		EnableApply();
		return true;
	}
}

function InpSwitchChange(obj)
{
	inp_switch_set = 1;
	SetColor(obj, "Yellow");
	EnableApply();
	return true;
}

function SpeedSelChange(obj)
{
	speed_sel_set = 1;
	SetColor(obj, "Yellow");
	EnableApply();
	return true;
}

function ValidateInpName(obj)
{
	var input_name = obj.value;	
	if(validateName(input_name, 0, language) == false)
	{
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;
}

function InpNameChange(obj)
{
	if(ValidateInpName(obj) == false)
	{
		inp_name_set = 2;
		SetColor(obj, "Red");
		return false;
	}
	else
	{
		inp_name_set = 1;
		SetColor(obj,"Yellow");
		EnableApply();
		return true;
	}
}

function ResetSetArrays()
{
	ip_addr_set    = 0;
	mask_set       = 0;
	gateway_set    = 0;
	inp_switch_set = 0;
	inp_name_set   = 0;
	speed_sel_set  = 0;
}

function ResetColor()
{
	document.getElementById("ip_addr").style.backgroundColor = "white";
	document.getElementById("subnet_mask").style.backgroundColor = "white";
	document.getElementById("gateway").style.backgroundColor = "white";
	document.getElementById("mac_addr").style.backgroundColor = "white";
	document.getElementById("inp_switch").style.backgroundColor = "white";
	document.getElementById("speed_sel").style.backgroundColor = "white";
	document.getElementById("speed_state").style.backgroundColor = "white";
	document.getElementById("gbe_inp_name").style.backgroundColor = "white";
}

function EnableApply()
{
	if(!PageLoadFlag)
	{
		disabledButton(document.getElementById("Apply"), false);
	}
}

function EnableReset()
{
	disabledButton(document.getElementById("Reset"), false);
}

function DisplayGbeParameters(response)
{
	var gbe_values = response.split("&");
	var response_index = 0;

	/*
	 * Here are what the responses are for the gbe:
	 * response[0]: ip address
	 * response[1]: subnet mask
	 * response[2]: mac address
	 * response[3]: input switch
	 * response[4]: speed select
	 * response[5]: speed state
	 * response[6]: gbe input name
	 */

	document.getElementById("ip_addr").value = gbe_values[response_index++];
	document.getElementById("subnet_mask").value = gbe_values[response_index++];
	document.getElementById("gateway").value = gbe_values[response_index++];
	document.getElementById("mac_addr").innerHTML = (gbe_values[response_index++]);
	document.getElementById("inp_switch").value = parseInt(gbe_values[response_index++]);
	document.getElementById("speed_sel").value = parseInt(gbe_values[response_index++]);
	document.getElementById("speed_state").innerHTML = gbe_values[response_index++];
	document.getElementById("gbe_inp_name").value = (gbe_values[response_index]);
}

// function to retrieve gbe parameters from the Card
function GetGbeParameters()
{
	var xmlhttp = getHTTPObject();
	var response;
	var getParams = "type=5&cmd=1&gbe_port=" + global_gbe_index + "&language=" + language;
	
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	if((bd.browser != "IE") && (language == 1))
	{
		xmlhttp.overrideMimeType("text/html;charset=gb2312");
	}
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);

	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			if((bd.browser == "IE") && (language == 1))
			{
				response = gb2utf8(xmlhttp.responseBody);
				var index = response.indexOf("</html>");
				var bias = response.length - index;
				response = response.slice(7, - bias);
			}
			else
			{
				response = xmlhttp.responseText.slice(7, -8);
			}
			DisplayGbeParameters(response);
		}
	}
	xmlhttp.send(getParams);
}

function PageLoadHandler()
{
	PageLoadFlag = 1;

	// disable the reset & apply buttons since this is fresh data
	disabledButton(document.getElementById("Reset"), true);
	disabledButton(document.getElementById("Apply"), true);

	window.status = "Retrieving data, please wait....";
	document.body.style.cursor = "wait";
	GetGbeParameters();
	ResetSetArrays();
	ResetColor();
	PageLoadFlag = 0;
	window.status = "Done";
	document.body.style.cursor = "auto";
	EnableReset();
}

/* function to reload the values */
function GbePortReload()
{
	PageLoadHandler();
}

window.onload = function()
{
	var args = getArgs();
	var nodeId = args["nodeId"];
	var group = args["group"];
	userName = args["userName"];
	if(nodeId == null)
	{
		nodeId = parent.curTree.getSelectedNodes()[0].nId;
	}
	var str = nodeId.split("_");
	card_index = parseInt(str[1]);
	gbe_index = parseInt(str[2]);
	global_gbe_index = card_index + "/" + gbe_index;	
	language = document.getElementById("language").value;
	// now set the GbE port value in the table
	document.getElementById("gbe_port").innerHTML = global_gbe_index;
	var apply = document.getElementById("Apply");
	applyDispay(group, apply);
	PageLoadHandler();
}

function ValidateGbeParam()
{
	var obj;
	var ip_value = document.getElementById("ip_addr").value;
	var mask_value = document.getElementById("subnet_mask").value;
	var gw_value = document.getElementById("gateway").value;
	if(ip_addr_set)
	{
		obj = document.getElementById("ip_addr");
		if(IPChange(obj) == false)
		{
			return false;
		}
	}
	
	obj = document.getElementById("subnet_mask");
	if(mask_set)
	{
		if(MaskChange(obj) == false)
		{
			return false;
		}
	}
	if(ip_addr_set || mask_set)
	{
		if(Validate_Subnet(ip_value, mask_value) == false)
		{
			if(language == 0)
			{
				alert("Subnet Mask and IP Address do not match .Please enter a valid Subnet Mask.")
			}
			else
			{
				alert("子网掩码和IP地址不相符，请输入一个有效的子网掩码。")
			}
			setTimeout(function () {obj.focus()}, 50);
			obj.select();
			return false;
		}
	}
	
	obj = document.getElementById("gateway");
	if(gateway_set)
	{
		if(GatewayChange(obj) == false)
		{
			return false;
		}
	}
	if((ip_addr_set || mask_set) || gateway_set)
	{
		if(gw_value != "0.0.0.0")
		{
			if(Valid_Gateway(ip_value, mask_value, gw_value) == false)
			{
				if(language == 0)
				{
					alert("Gateway and IP Address do not fall in the same network .Please enter a valid Gateway.")
				}
				else
				{
					alert("网关和IP地址没有落到同一网段，请输入一个有效的网关。")
				}
				setTimeout(function () {obj.focus()}, 50);
				obj.select();
				return false;
			}
		}
	}
	
	if(inp_name_set)
	{
		obj = document.getElementById("gbe_inp_name");
		if(InpNameChange(obj) == false)
		{
			return false;
		}
	}
	return true;
}

/* function to set the GbE port parameters */
function GenerateGbeParameter()
{
	var Params = "type=5&cmd=2&userName=" + userName + "&gbe_port=" + global_gbe_index + "&";
    var PortUpdate = "112233";
	// use the set arrays to tell if something needs to be saved
	// there is no need to check annex type or anything since that is already
	//  handled based on the page display
	if(ip_addr_set == 1)
	{
		var IPAddress = document.getElementById("ip_addr").value;
		Params = Params + "ip_addr=" + IPAddress + "&";
	}
	if(mask_set == 1)
	{
		var Mask = document.getElementById("subnet_mask").value;
		Params = Params + "subnet_mask=" + Mask + "&";
	}
	if(gateway_set == 1)
	{
		var Gateway = document.getElementById("gateway").value;
		Params = Params + "gateway=" + Gateway + "&";
	}
	if(inp_switch_set == 1)
	{
		var InpSwitch = document.getElementById("inp_switch").value;
		Params = Params + "inp_switch=" + InpSwitch + "&";
	}
	if(inp_name_set == 1)
	{
		var InpName = document.getElementById("gbe_inp_name").value
		Params = Params + "gbe_inp_name=" + InpName + "&";
	}
	if(speed_sel_set == 1)
	{
		var SpeedSel = document.getElementById("speed_sel").value
		Params = Params + "speed_sel=" + SpeedSel + "&";
	}
	Params = Params + "Update=" + PortUpdate;
	return Params;
}

function GbeSetValue()
{
  /* depending on the node value post the data*/
 	var xmlhttp = false;
	var params;

	/* Generate params to POST from the from controls */
	params = GenerateGbeParameter();

 	xmlhttp = getHTTPObject();
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", params.length);

	xmlhttp.onreadystatechange = function()
	{
   		if(xmlhttp.readyState == 4)
   		{
			if(language == 0)
			{
				alert("Gbe configuration modified successfully.");
			}
			else
			{
				alert("Gbe参数设置成功。");
			}
			PageLoadHandler();
   		}
	}

	xmlhttp.send(params);
}

/*Post the values */
function GbePortApply()
{
	if(ValidateGbeParam() == false)
	{
		return false;
	}

	disabledButton(document.getElementById("Reset"), true);
	disabledButton(document.getElementById("Apply"), true);
	window.status = "Applying changes, please wait...";
	document.body.style.cursor="wait";
	GbeSetValue();
}
